;
;								EJEMPLO 15
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;La memoria EEPROM de datos.La mquina "SU TURNO"
;
;Se trata de emular el funcionamiento de las mquinas tipo "SU TURNO" habituales en mltiples
;comercios. Sobre el display se visualizar el nmero del turno actual. Este se icrementa a
;cada pulso aplicado por RA0. En la memoria EEPROM del PIC16F876 se almacena el ltimo nmero
;visualizado, de forma que, ante un fallo de alimentacin (p.e.), se reanude la cuenta en el
;ltimo nmero.
;
;Si se parte de que el sistema se emplea por vez primera , se visualiza el 0

			List	p=16F876A		;Tipo de procesador
			include	"P16F876A.INC"	;Definiciones de registros internos
        
;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
            		
Contador		equ	0x20				;Variable para el contador

				org	0x00	
				goto	Inicio
				org	0x05

;****************************************************************************************
;EE_Write: Graba un byte en la EEPROM de datos. La direccin ser la contenida en EEADR y
;el dato se le supone previamente metido en EEDATA

EE_Write      	bsf    	STATUS,RP0
				bsf		STATUS,RP1		;Selecciona banco 3
				bcf		EECON1,EEPGD	;Acceso a EEPROM de datos
				bsf    	EECON1,WREN		;Permiso de escritura
               	movlw  	b'01010101'
               	movwf  	EECON2
               	movlw  	b'10101010'
               	movwf  	EECON2			;Secuencia establecida por Microchip
               	bsf    	EECON1,WR		;Orden de escritura
Wait           	btfsc  	EECON1,WR		;Testear flag de fin de escritura
               	goto   	Wait
				bcf    	EECON1,WREN		;Desconecta permiso de escritura             
				bcf    	EECON1,EEIF		;Reponer flag de fin de escritura
               	bcf    	STATUS,RP0
               	bcf		STATUS,RP1		;Selecciona banco 0
				return

;**************************************************************************************
;EE_Read: Leer un byte de la EEPROM. Se supone al registro EEADR cargado con la direc-
;cin a leer. En EEDATA aparecer el dato ledo.

EE_Read        	bsf     STATUS,RP0	
				bsf		STATUS,RP1		;Seleccin de banco 3
               	bcf		EECON1,EEPGD	;Selecciona EEPROM de datos
				bsf    	EECON1,RD		;Orden de lectura
               	bcf    	STATUS,RP0	
				bcf		STATUS,RP0		;Seleccin de banco 0
                return

;**********************************************************************************
;Tabla: Esta rutina convierte el cdigo BCD presente en los 4 bits de menos peso
;del reg. W en su equivalente a 7 segmentos. El cdigo 7 segmentos retorna tambin
;en el reg. W

Tabla:			addwf	PCL,F			;Desplazamiento sobre la tabla
				retlw	b'00111111'		;Dgito 0
				retlw	b'00000110'		;Dgito 1
				retlw	b'01011011'		;Dgito 2
				retlw	b'01001111'		;Dgito 3
				retlw	b'01100110'		;Dgito 4
				retlw	b'01101101'		;Dgito 5
				retlw	b'01111101'		;Dgito 6
				retlw	b'00000111'		;Dgito 7
				retlw	b'01111111'		;Dgito 8
				retlw	b'01100111'		;Dgito 9

;*********************************************************************************
;Delay_10_ms: Esta rutina de temporizacin tiene por objeto eleiminar el "efecto
;rebote" de los perifricos electromecnicos. 

Delay_10_ms:	bcf		INTCON,T0IF		;Desconecta el flag de rebosamiento
				movlw	~.39		
				movwf	TMR0			;carga el TMR0 con 39
Delay_10_ms_1	btfss	INTCON,T0IF		;Rebasamiento del TMR0 ??
				goto	Delay_10_ms_1	;Todava no
				bcf		INTCON,T0IF		;Ahora si, reponer el flag
				return

Inicio	       	clrf 	PORTB			;Borra los latch de salida
				bsf		STATUS,RP0		;Selecciona banco 1
				clrf	TRISB			;Puerta B se configura como salida
				movlw	0x06
				movwf	ADCON1			;Puerta A digital
				movlw	b'00111111'		
				movwf	TRISA			;Puerta A se configura como entrada		
				movlw	b'00000111'
				movwf	OPTION_REG		;Preescaler de 256 para el TMR0
				bcf		STATUS,RP0		;Selecciona banco 0			                                                                         					

				bsf		STATUS,RP1		;Selecciona banco 2
				clrf	EEADR			;Selecciona direccin 00 de EEPROM				
				call	EE_Read			;Lee byte de la EEPROM
				bsf		STATUS,RP1		;Selecciona banco 2
				movlw	0x09
				subwf	EEDATA,W
				btfsc	STATUS,C		;Mayor de 9 ??		
				goto	Ini_0			;Si, poner a 0 el contador
				goto	Ini_1			;No
Ini_0			bcf		STATUS,RP1		;Banco 0
				clrf	Contador		;Poner a 0 el contador
				goto	Loop
Ini_1			movf	EEDATA,W
				bcf		STATUS,RP1		;Banco 0
				movwf	Contador		;Iniciar contador

Loop			movf	Contador,W
				call	Tabla			;Convierte contador a 7 segmentos
				movwf	PORTB			;Visualiza sobre el display
		
Wait_0			btfsc	PORTA,0			;RA0 est a "0" ??
				goto	Wait_0			;No, esperar
				call	Delay_10_ms		;Eliminar rebotes

Wait_1			btfss	PORTA,0			;RA0 est a "1" ??
				goto	Wait_1			;No, esperar
				call	Delay_10_ms		;Eliminar rebotes. Ha habido un pulso
				incf	Contador,F		;Incrementa contador
				movlw	.10
				subwf	Contador,W
				btfsc	STATUS,Z		;Contador mayor de 9 ??
				clrf	Contador		;Si, vuelta a 00
				movf	Contador,W
				bsf		STATUS,RP1		;Banco 2
				movwf	EEDATA
				call	EE_Write		;Graba el nuevo valor del contador en la EEPROM
				goto	Loop

				end						;Fin del programa fuente

